<?php
/**
 * Avalanche for Magento 1.8+
 * Designed by Fast Division (http://fastdivision.com)
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://fastdivision.com/legal/license.txt
 *
 * @author     Fast Division
 * @version    1.5.0
 * @copyright  Copyright 2013 Fast Division
 * @license    http://fastdivision.com/legal/license.txt
 */

$installer = $this;
$installer->startSetup();

// Add Mobile Description to Manage Products Individual Page
try {
    $setup = new Mage_Eav_Model_Entity_Setup('core_setup');
    $setup->removeAttribute('catalog_category', 'microformat_category');
    $setup->addAttribute('catalog_category', 'microformat_category', array(
            'label' => 'Microformat Category',
            // 'comment' => '<![CDATA[To learn how to use the product category microformat, <a href="http://support.google.com/merchants/bin/answer.py?hl=en&answer=160081" target="_blank">click here for more information. Make sure "Use Microformat Categories" is set to "Yes" under Search Engine Optimization.</a>]]>',
            'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
            'type' => 'varchar',
            'input' => 'text',
            'visible' => true,
            'required' => false,
        ));
} catch(Exception $e) {
    Mage::logException($e);
}

$installer->endSetup();